/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Number;
import BryceMath.Numbers.Rational;

public class Complex
extends Number<Complex> {
    private Rational real;
    private Rational imaginary;
    public static final Complex ZERO = new Complex(0);
    public static final Complex ONE = new Complex(1);
    public static final Complex I = new Complex(0, 1);

    public Complex(Rational real, Rational imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public Complex(Rational real) {
        this.real = real;
        this.imaginary = Rational.ZERO;
    }

    public Complex(IntB real) {
        this.real = new Rational(real);
        this.imaginary = Rational.ZERO;
    }

    public Complex(long real) {
        this.real = new Rational(real);
        this.imaginary = Rational.ZERO;
    }

    public Complex(int real) {
        this.real = new Rational(real);
        this.imaginary = Rational.ZERO;
    }

    public Complex(int real, int imaginary) {
        this.real = new Rational(real);
        this.imaginary = new Rational(imaginary);
    }

    public Complex(long real, long imaginary) {
        this.real = new Rational(real);
        this.imaginary = new Rational(imaginary);
    }

    private Complex C(Rational r, Rational i) {
        if (i.eq(0)) {
            if (r.eq(0)) {
                return ZERO;
            }
            if (r.eq(1)) {
                return ONE;
            }
        }
        return new Complex(r, i);
    }

    @Override
    protected Complex N(long input) {
        if (input == 0L) {
            return ZERO;
        }
        if (input == 1L) {
            return ONE;
        }
        return new Complex(input);
    }

    @Override
    public Complex conj() {
        return this.C(this.real, this.imaginary.neg());
    }

    @Override
    public Complex add(Complex n) {
        return this.C(this.real.add(n.real), this.imaginary.add(n.imaginary));
    }

    @Override
    public Complex sub(Complex n) {
        return this.C(this.real.sub(n.real), this.imaginary.sub(n.imaginary));
    }

    @Override
    public Complex div(Complex n) {
        Rational r = this.real.mult(n.real).add(this.imaginary.mult(n.imaginary)).div(n.real.mult(n.real).add(n.imaginary.mult(n.imaginary)));
        Rational i = this.imaginary.mult(n.real).sub(this.real.mult(n.imaginary)).div(n.real.mult(n.real).add(n.imaginary.mult(n.imaginary)));
        return this.C(r, i);
    }

    @Override
    public boolean eq(Complex other) {
        return this.real.eq(other.real) && this.imaginary.eq(other.imaginary);
    }

    @Override
    public Complex mult(Complex n) {
        Rational r = this.real.mult(n.real).sub(this.imaginary.mult(n.imaginary));
        Rational i = this.real.mult(n.imaginary).add(this.imaginary.mult(n.real));
        return this.C(r, i);
    }

    @Override
    public Complex sqrt() {
        throw new Error("Complex square roots have not yet be conceptualized.");
    }

    @Override
    public Complex one() {
        return ONE;
    }

    @Override
    public Complex zero() {
        return ZERO;
    }

    public Rational part_real() {
        return this.real;
    }

    public Rational part_imaginary() {
        return this.imaginary;
    }

    @Override
    public int hashCode() {
        return this.real.hashCode() + this.imaginary.hashCode();
    }

    @Override
    public Complex neg() {
        return new Complex(this.real.neg(), this.imaginary.neg());
    }

    @Override
    public boolean isNegative() {
        return this.sign() == -1;
    }

    @Override
    public boolean isPositive() {
        return this.sign() == 1;
    }

    @Override
    public int sign() {
        int output = this.real.sign();
        if (output != 0) {
            return output;
        }
        return this.imaginary.sign();
    }

    @Override
    public Complex abs() {
        if (this.sign() < 0) {
            return this.neg();
        }
        return this;
    }

    public static Complex power_of_i(int i) {
        return Complex.power_of_i(new IntB(i));
    }

    public static Complex power_of_i(IntB i) {
        int Case = ((IntB)i.mod(4)).toInt();
        switch (Case) {
            case 0: {
                return ONE;
            }
            case -3: 
            case 1: {
                return I;
            }
            case -2: 
            case 2: {
                return ONE.neg();
            }
            case -1: 
            case 3: {
                return I.neg();
            }
        }
        throw new Error("Something is wrong with IntB.mod");
    }

    @Override
    public boolean isInt() {
        return this.imaginary.eq(0) && this.real.isInt();
    }

    @Override
    public IntB toIntB() {
        return this.real.toIntB();
    }

    @Override
    public int toInt() {
        return this.real.toInt();
    }

    @Override
    public String toString() {
        if (this.imaginary.eq(0)) {
            return "" + this.real;
        }
        if (this.real.eq(0)) {
            return this.imaginary.toCoef() + " i";
        }
        if (this.imaginary.isPositive()) {
            return this.real + " + " + this.imaginary.toCoef() + "i";
        }
        return this.real + " - " + this.imaginary.abs().toCoef() + "i";
    }

    public String toSerialString() {
        if (this.eq(0)) {
            return "0";
        }
        if (this.imaginary.eq(0)) {
            return this.real.toSerialString();
        }
        if (this.real.eq(0)) {
            return String.valueOf(this.imaginary.toSerialString()) + "i";
        }
        return String.valueOf(this.real.toSerialString()) + " + " + this.imaginary.toSerialString() + "i";
    }
}

